// BoggleGame.java
//
// Solution by:
//
//		Jason W. Pegg
//		Senior Network Engineer
//		Aurora Development Group
//
// For:
//
//		The ACM Pacific NW Region Programming Contest
//		November 15, 1997
//
// Problem E - The Boggle Game
//

import java.io.*;
import java.util.Vector;
import QuickSort;

public class BoggleGame
{
	// set up some global attributes
	char chrFirstBoard[][] = new char[4][4];	// first boggle board
	char chrSecondBoard[][] = new char[4][4];	// second boggle board
	int intPositionGrid[][] = new int[4][4];	// grid to indicate taken positions
	int intFBCount;								// count of words in first board
	int intSBCount;								// count of words in second board
	Vector vctFBWords = new Vector(20, 10);		// vector of words found in first board
	Vector vctSBWords = new Vector(20, 10);		// vector of words found in second board


	public static void main(String args[])
	{
		// create the boggle instance
		BoggleGame boggle = new BoggleGame();

		// start playing
		boggle.PlayTheGame();
	}


	void PlayTheGame()
	{
		// set up the local attributes
		String strInputFilename = new String("boggle.dat");		// name of input file
		FileInputStream fisInputStream;							// file input stream
		char chrInputChar;										// character input
		int i, j;												// counter variables
		boolean bolMatch;										// indicates a match


		// set up the input stream
		try {
			fisInputStream = new FileInputStream(strInputFilename);
		}
		catch (java.io.FileNotFoundException e) {
			return;
		}

		DataInputStream disInput = new DataInputStream(fisInputStream);


		// get the first character
		try {
			chrInputChar = (char)disInput.readByte();
			while (chrInputChar < 35)
				chrInputChar = (char)disInput.readChar();
		}
		catch (java.io.IOException e) {
			System.out.println("Error reading input file.");
			return;
		}


		// continue processing until we hit a '#'
		while (chrInputChar != '#')
		{
			// read in the two board grids
			for (i = 0; i < 4; i++)
			{
				for (j = 0; j < 8; j++)
				{
					if (j < 4)
						chrFirstBoard[i][j] = chrInputChar;
					else
						chrSecondBoard[i][j-4] = chrInputChar;

					// get the next character
					try {
						chrInputChar = (char)disInput.readByte();
						while (chrInputChar < 35)
							chrInputChar = (char)disInput.readByte();
					}
					catch (java.io.IOException e) {
						System.out.println("Error reading input file.");
						return;
					}
				}
			}


			// initialize the counters
			intFBCount = 0;
			intSBCount = 0;

			// initialize the position grid
			for (i = 0; i < 4; i++)
			{
				for (j = 0; j < 4; j++)
					intPositionGrid[i][j] = 0;
			}

			// go through every position in the first board and find all words
			for (i = 0; i < 4; i++)
			{
				for (j = 0; j < 4; j++)
					FindWords(0, i, j, 0, String.valueOf(chrFirstBoard[i][j]));
			}

			// re-initialize the position grid
			for (i = 0; i < 4; i++)
			{
				for (j = 0; j < 4; j++)
					intPositionGrid[i][j] = 0;
			}

			// go through every position in the second board and find all words
			for (i = 0; i < 4; i++)
			{
				for (j = 0; j < 4; j++)
					FindWords(1, i, j, 0, String.valueOf(chrSecondBoard[i][j]));
			}


			// now sort the lists
			QuickSort qs = new QuickSort(vctFBWords);
			qs.StartSort();

			qs.AssignNew(vctSBWords);
			qs.StartSort();


			// initialize the matching flag
			bolMatch = false;

			// pick the shortest list, and start looking for matches
			if (vctFBWords.size() <= vctSBWords.size())
			{
				for (i = 0; i < vctFBWords.size(); i++)
				{
					if (vctSBWords.contains((String)vctFBWords.elementAt(i)))
					{
						bolMatch = true;
						System.out.println((String)vctFBWords.elementAt(i));
					}
				}
			}
			else
			{
				for (i = 0; i < vctSBWords.size(); i++)
				{
					if (vctFBWords.contains((String)vctSBWords.elementAt(i)))
					{
						bolMatch = true;
						System.out.println((String)vctSBWords.elementAt(i));
					}
				}
			}

			// if there were no matches, indicate as much - blank line regardless
			if (!bolMatch)
				System.out.println("There are no common words for this pair of boggle boards.");

			System.out.println();


			// clean up the mess we've made to get ready for the next set (if any)
			vctFBWords.removeAllElements();
			vctSBWords.removeAllElements();
		}
	}




	void FindWords(int intBoard,			// indicates first or second board
					int intX,				// X position within the board
					int intY,				// Y position within the board
					int intElement,			// the current letter we're on
					String strLetters)		// the letters collected thus far
	{
		int i, j;							// counter variables

		// mark this spot as taken in tht global grid
		intPositionGrid[intX][intY] = 1;

		
		// if there are more letters to gather...
		if (intElement < 3)
		{
			// cycle through the permitted letters around the current position
			for (i = -1; i <= 1; i++)
			{
				for (j = -1; j <= 1; j++)
				{
					// if the index is valid...
					if ((intX + i >= 0) && (intX + i < 4) &&
						(intY + j >= 0) && (intY + j < 4))
					{
						// if the cell is not marked as used...
						if (intPositionGrid[intX+i][intY+j] == 0)
						{
							// make the recursive call depending on the board
							if (intBoard == 0)
								FindWords(intBoard, intX+i, intY+j, intElement+1,
									strLetters + chrFirstBoard[intX+i][intY+j]);
							else
								FindWords(intBoard, intX+i, intY+j, intElement+1,
									strLetters + chrSecondBoard[intX+i][intY+j]);
						}
					}
				}
			}
		}

		// otherwise, we have no more letters to pick...
		else
		{
			// initialize a vowel count
			int intVowelCount = 0;


			// count the vowels
			if ((strLetters.charAt(0) == 'A') || (strLetters.charAt(0) == 'E') ||
				(strLetters.charAt(0) == 'I') || (strLetters.charAt(0) == 'O') ||
				(strLetters.charAt(0) == 'U') || (strLetters.charAt(0) == 'Y'))
				intVowelCount = 10;	// make sure it fails
			if ((strLetters.charAt(1) == 'A') || (strLetters.charAt(1) == 'E') ||
				(strLetters.charAt(1) == 'I') || (strLetters.charAt(1) == 'O') ||
				(strLetters.charAt(1) == 'U') || (strLetters.charAt(1) == 'Y'))
				intVowelCount++;
			if ((strLetters.charAt(2) == 'A') || (strLetters.charAt(2) == 'E') ||
				(strLetters.charAt(2) == 'I') || (strLetters.charAt(2) == 'O') ||
				(strLetters.charAt(2) == 'U') || (strLetters.charAt(2) == 'Y'))
				intVowelCount++;
			if ((strLetters.charAt(3) == 'A') || (strLetters.charAt(3) == 'E') ||
				(strLetters.charAt(3) == 'I') || (strLetters.charAt(3) == 'O') ||
				(strLetters.charAt(3) == 'U') || (strLetters.charAt(3) == 'Y'))
				intVowelCount++;

			// if the vowel count is proper...
			if ((intVowelCount == 1) || (intVowelCount == 2))
			{
				// if we're dealing with the first board...
				if (intBoard == 0)
				{
					// if the word's not in the list, add it
					if (!vctFBWords.contains(strLetters))
						vctFBWords.addElement(strLetters);
				}

				// otherwise, we're looking at the second board...
				else
				{
					// if the word's not in the list, add it
					if (!vctSBWords.contains(strLetters))
						vctSBWords.addElement(strLetters);
				}
			}
		}


		// unmark the spot on the global position grid
		intPositionGrid[intX][intY] = 0;
	}



}

